﻿var surveyProperties = {
    context: $(".v-surveyProperties"),    
    initialize: function () {
        var userGroupsContainer = $(".v-userGroupSelectContainer", surveyProperties.context);

        surveyProperties.useS2InitialValue = a4.getInputValue($("#UseS2", surveyProperties.context));

        $(".h-userGroupsMultiSelect", userGroupsContainer).a4autocomplete({
            ajaxAction: a4.getAction("GetUserGroups", "Users", "Settings"),
            valueProperty: "Id",
            labelProperty: "Name",
            multipleSelection: true,
            hideSelectedItems: true,
            altValueField: $("#UserGroupsJson", userGroupsContainer)
        });

        surveyProperties.context.on("change", "#IsOffline", function () {
            var isActive = $("#Status", surveyProperties.context).val() == "Active";
            var isOffline = $(this).val() == "True";            
            $(".v-offlineUserGroupsSection", surveyProperties.context).toggle(isOffline);
            $(".v-useS2Section input", surveyProperties.context).prop("disabled", isActive || isOffline);
        });

        surveyProperties.context.on("change", "#UseS2", function () {
            var useS2 = $(this).val() == "True";
            $(".v-isOfflineSection input", surveyProperties.context).prop("disabled", useS2);
        });
    },
    bindEvents: function () {
        surveyProperties.context.on("click", "#submit1", function (e) {
            var form = surveyProperties.context.parent("form");
            e.preventDefault();

            a4.appendAntiForgeryToken(form);

            if ($(".v-useS2Section input", surveyProperties.context).prop("disabled")) {
                $(".v-useS2Section input", surveyProperties.context).prop("disabled", false);
            }

            if ($(".v-isOfflineSection input", surveyProperties.context).prop("disabled")) {
                $(".v-isOfflineSection input", surveyProperties.context).prop("disabled", false);
            }

            if (surveyProperties.useS2InitialValue != a4.getInputValue($("#UseS2", surveyProperties.context))) {
                modalDialog.showConfirmDialog(toggleS2Message, function () {
                    form.trigger("submit");
                }, 281, 500);
            }
            else {
                form.trigger("submit");
            }

            return false;
        });
    }
};

$(document).ready(function () {
    if (surveyProperties.context.length > 0) {
        surveyProperties.initialize();
        surveyProperties.bindEvents();
    }    
});